//
// Created by sachetto on 19/03/2021.
//

#include "helper_functions.h"
#include <stdlib.h>
#include "../config_helpers/config_helpers.h"
#include <stdio.h>


#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <complex.h>
#include <assert.h>
#include "cnpy.h"

struct extra_data_for_fibrosis* set_common_schemia_data(struct config *config, uint32_t num_cells) {
   printf ("SETTING COMMON ISCHEMIA DATA\n");

    struct extra_data_for_fibrosis *extra_data = MALLOC_ONE_TYPE(struct extra_data_for_fibrosis);
	
	extra_data->sv0_ctrlNorm = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->sv0_ctrlIsch = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->sv0_hcmNorm = MALLOC_ARRAY_OF_TYPE(real, 43);
	extra_data->sv0_hcmIsch = MALLOC_ARRAY_OF_TYPE(real, 43);
	
    real f = 0.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, f, config, "f");

    real Ko = 5.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, Ko, config, "Ko");

    real INaFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaFactor, config, "INaFactor");

    real ICaLFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, ICaLFactor, config, "ICaLFactor");

    real hcmIn = 0.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, hcmIn, config, "hcmIn");

    real hcmOut = 0.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, hcmOut, config, "hcmOut");
	
	real INaKFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaKFactor, config, "INaKFactor");
	
	real INaCaFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaCaFactor, config, "INaCaFactor");
	
	real INaLFactor = 1.0f;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, INaLFactor, config, "INaLFactor");

    real mCaL = 1.0f;
    real mNa = 1.0f;
    real mto = 1.0f;
    real mNaL = 1.0f;
    real mKr = 1.0f;
    real mKs = 1.0f;
    real mK1 = 1.0f;
    real mNaCa = 1.0f;
    real mNaK = 1.0f;
    real mRel = 1.0f;
    real mUp = 1.0f;

    real modelID = 50000;
    GET_PARAMETER_NUMERIC_VALUE_OR_USE_DEFAULT(real, modelID, config, "modelID");

  //modelID = modelID - 1;

  if(modelID != 50000){
  

  char *fn = "/mnt/lustre/indy2lfs/work/d411/d411/jcoleman/MonoAlg3D_C/src/extra_data_library/sf_cal1.npy";
  cnpy_array a;
  bool writable = false;
  if (cnpy_open(fn, writable, &a) != CNPY_SUCCESS) {
    cnpy_perror("Unable to load file");
    abort();
  }
  assert(a.dtype == CNPY_F8); /* F8 == double */
  assert(a.n_dim == 2);
  size_t index[] = {0, 0};
  for (index[0] = 0; index[0] < a.dims[0]; index[0] += 1) {
    for (index[1] = 0; index[1] < a.dims[1]; index[1] += 1) {
        real x = cnpy_get_f8(a, index);
        cnpy_set_f8(a, index, index[0]+index[1]);

		if(index[0] == modelID){
		
			if(index[1]==0){mCaL=x;}
			else if(index[1]==1){mNa=x;}
			else if(index[1]==2){mto=x;}
			else if(index[1]==3){mNaL=x;}
			else if(index[1]==4){mKr=x;}
			else if(index[1]==5){mKs=x;}
			else if(index[1]==6){mK1=x;}
			else if(index[1]==7){mNaCa=x;}
			else if(index[1]==8){mNaK=x;}
			else if(index[1]==9){mRel=x;}
			else if(index[1]==10){mUp=x;}
        }
	}
  }
  if (cnpy_close(&a) != CNPY_SUCCESS) {
    cnpy_perror("Unable to close file");
    abort();
  }


  printf("CTRL NORMAL\n");
  char *fn0 = "/mnt/lustre/indy2lfs/work/d411/d411/jcoleman/MonoAlg3D_C/src/extra_data_library/ctrlnormal.npy";
  cnpy_array a0;
  bool writable0 = false;
  if (cnpy_open(fn0, writable0, &a0) != CNPY_SUCCESS) {
    cnpy_perror("Unable to load file");
    abort();
  }
  assert(a0.dtype == CNPY_F8); /* F8 == double */
  assert(a0.n_dim == 2);
  size_t index0[] = {0, 0};
  for (index0[0] = 0; index0[0] < a0.dims[0]; index0[0] += 1) {
    for (index0[1] = 0; index0[1] < a0.dims[1]; index0[1] += 1) {
      real x0 = cnpy_get_f8(a0, index0);
      cnpy_set_f8(a0, index0, index0[0]+index0[1]);
    
    if(index0[0] == modelID){
	
		extra_data->sv0_ctrlNorm[index0[1]] = x0;
		printf("%d %d %lf \n", index0[0], index0[1], x0);}

    }
  }
  if (cnpy_close(&a0) != CNPY_SUCCESS) {
    cnpy_perror("Unable to close file");
    abort();
  }
  
  char *fn1 = "/mnt/lustre/indy2lfs/work/d411/d411/jcoleman/MonoAlg3D_C/src/extra_data_library/ctrlisch.npy";
  cnpy_array a1;
  bool writable1 = false;
  if (cnpy_open(fn1, writable1, &a1) != CNPY_SUCCESS) {
    cnpy_perror("Unable to load file");
    abort();
  }
  assert(a1.dtype == CNPY_F8); /* F8 == double */
  assert(a1.n_dim == 2);
  size_t index1[] = {0, 0};
  for (index1[0] = 0; index1[0] < a1.dims[0]; index1[0] += 1) {
    for (index1[1] = 0; index1[1] < a1.dims[1]; index1[1] += 1) {
      real x1 = cnpy_get_f8(a1, index1);
      cnpy_set_f8(a1, index1, index1[0]+index1[1]);

    if(index1[0] == modelID){
	
		extra_data->sv0_ctrlIsch[index1[1]] = x1;
		printf("%d %d %lf \n", index1[0], index1[1], x1);}
    }
  }
  if (cnpy_close(&a1) != CNPY_SUCCESS) {
    cnpy_perror("Unable to close file");
    abort();
  }
  
  
  char *fn2 = "/mnt/lustre/indy2lfs/work/d411/d411/jcoleman/MonoAlg3D_C/src/extra_data_library/hcmnormal.npy";
  cnpy_array a2;
  bool writable2 = false;
  if (cnpy_open(fn2, writable2, &a2) != CNPY_SUCCESS) {
    cnpy_perror("Unable to load file");
    abort();
  }
  assert(a2.dtype == CNPY_F8); /* F8 == double */
  assert(a2.n_dim == 2);
  size_t index2[] = {0, 0};
  for (index2[0] = 0; index2[0] < a2.dims[0]; index2[0] += 1) {
    for (index2[1] = 0; index2[1] < a2.dims[1]; index2[1] += 1) {
      real x2 = cnpy_get_f8(a2, index2);
      cnpy_set_f8(a2, index2, index2[0]+index2[1]);

    if(index2[0] == modelID){
	
		extra_data->sv0_hcmNorm[index2[1]] = x2;
		printf("%d %d %lf \n", index2[0], index2[1], x2);}
    }
  }
  if (cnpy_close(&a2) != CNPY_SUCCESS) {
    cnpy_perror("Unable to close file");
    abort();
  }
  
  char *fn3 = "/mnt/lustre/indy2lfs/work/d411/d411/jcoleman/MonoAlg3D_C/src/extra_data_library/hcmisch.npy";
  cnpy_array a3;
  bool writable3 = false;
  if (cnpy_open(fn3, writable3, &a3) != CNPY_SUCCESS) {
    cnpy_perror("Unable to load file");
    abort();
  }
  assert(a3.dtype == CNPY_F8); /* F8 == double */
  assert(a3.n_dim == 2);
  size_t index3[] = {0, 0};
  for (index3[0] = 0; index3[0] < a3.dims[0]; index3[0] += 1) {
    for (index3[1] = 0; index3[1] < a3.dims[1]; index3[1] += 1) {
      real x3 = cnpy_get_f8(a3, index3);
      cnpy_set_f8(a3, index3, index3[0]+index3[1]);

    if(index3[0] == modelID){
	
		extra_data->sv0_hcmIsch[index3[1]] = x3;
		printf("%d %d %lf \n", index3[0], index3[1], x3);}
    }
  }
  if (cnpy_close(&a3) != CNPY_SUCCESS) {
    cnpy_perror("Unable to close file");
    abort();
  }
  }
  
  
  
 
    extra_data->INaFactor = INaFactor;
    extra_data->ICaLFactor = ICaLFactor;
    extra_data->Ko = Ko;
    extra_data->f = f;
    extra_data->hcmIn = hcmIn;
    extra_data->hcmOut = hcmOut;
	
	extra_data->INaKFactor = INaKFactor;
	extra_data->INaCaFactor = INaCaFactor;
	extra_data->INaLFactor = INaLFactor;

    extra_data->mCaL=mCaL;
    extra_data->mNa=mNa;
    extra_data->mto=mto;
    extra_data->mNaL=mNaL;
    extra_data->mKr=mKr;
    extra_data->mKs=mKs;
    extra_data->mK1=mK1;
    extra_data->mNaCa=mNaCa;
    extra_data->mNaK=mNaK;
    extra_data->mRel=mRel;
    extra_data->mUp=mUp;

    extra_data->modelID=modelID;

    extra_data->fibrosis = MALLOC_ARRAY_OF_TYPE(real, num_cells);
    

    return extra_data;
}